% Shlomi_method.m
% Chris Gowen
% April, 2012
% 
% This script is provided to accompany the chapter "Linking RNA 
% measurements and proteomics with genome-scale models" in Methods in
% Molecular Biology: Systems Metabolic Engineering, ed. Hal Alper
%
% It is provided for educational purposes only, without any warranty.

milp_ss = struct;
milp_5h = struct;
load iMM904.mat
epsilon = .05;

% Set glucose uptake to reflect observation within 10% error. O2 is 
% saturated, so don't limit O2 uptake.
model_ss = changeRxnBounds(model,{'EX_glc(e)' 'EX_o2(e)'},...
    [-0.9376*1.1 -1000],'l');
model_5h = changeRxnBounds(model,{'EX_glc(e)' 'EX_o2(e)'},...
    [-3.2752*1.1 -1000],'l');

% Since Shlomi method is independent of a biological objective function,
% set growth rate to match measured value for improved accuracy, within 10%
% error.
model_ss = changeRxnBounds(model_ss, {'biomass_SC5_notrace'},0.1*1.1,'u');
model_ss = changeRxnBounds(model_ss, {'biomass_SC5_notrace'},0.1*0.9,'l');

model_5h = changeRxnBounds(model_5h, {'biomass_SC5_notrace'},0.1895*1.1,'u');
model_5h = changeRxnBounds(model_5h, {'biomass_SC5_notrace'},0.1895*0.9,'l');

% Find reactions which should be low
low_transcr_names_ss = transcr_IDs(low_transcr{3});
low_transcr_names_5h = transcr_IDs(low_transcr{14});
lowRxns_ss = mapGeneCalls(low_transcr_names_ss,'low',model);
lowRxns_5h = mapGeneCalls(low_transcr_names_5h,'low',model);

% Find reactions which should be high
high_transcr_names_ss = transcr_IDs(high_transcr{3});
high_transcr_names_5h = transcr_IDs(high_transcr{14});
highRxns_ss = mapGeneCalls(high_transcr_names_ss,'high',model);
highRxns_5h = mapGeneCalls(high_transcr_names_5h,'high',model);

% x = [ v(1:nRxns) yf_l(1:nLowRxns) yf_h(1:HighRxns) yr_h(1:HighRxns) ] 
nVar_ss = length(model_ss.rxns)+length(lowRxns_ss)+2*length(highRxns_ss);
nVar_5h = length(model_5h.rxns)+length(lowRxns_5h)+2*length(highRxns_5h);
ny_ss = nVar_ss - length(model_ss.rxns);
ny_5h = nVar_5h - length(model_5h.rxns);
nMets = length(model.mets);
nRxns = length(model.rxns);

% S*v = 0
milp_ss.Aeq = [model_ss.S zeros(nMets,ny_ss)];
milp_5h.Aeq = [model_5h.S zeros(nMets,ny_5h)];
milp_ss.beq = model_ss.b;
milp_5h.beq = model_5h.b;

milp_ss.Aineq = zeros(2*length(lowRxns_ss)+2*length(highRxns_ss),nVar_ss);
milp_5h.Aineq = zeros(2*length(lowRxns_5h)+2*length(highRxns_5h),nVar_5h);
milp_ss.bineq = zeros(2*length(lowRxns_ss)+2*length(highRxns_ss),1);
milp_5h.bineq = zeros(2*length(lowRxns_5h)+2*length(highRxns_5h),1);

for l=1:length(lowRxns_ss)
    rxnID_ = lowRxns_ss(l);
    v_min_ = model_ss.lb(l);
    v_max_ = model_ss.ub(l);
    
    % v_l <= v_max_l*(1-yf_l), l in low reactions
    % v_l + v_max_l*yf_l <= v_max_l
    i = l;
    milp_ss.Aineq(i,rxnID_) = 1;                %v_l
    milp_ss.Aineq(i,nRxns+l) = v_max_;          %v_max_l*yf_l
    milp_ss.bineq(i) = v_max_;                  %v_max_l
    
    % v_min_l*(1-yf_l) <= v_l, l in low reactions
    % -v_l - v_min_l*yf_l <= -v_min_l
    i = length(lowRxns_ss) + l;
    milp_ss.Aineq(i,rxnID_) = -1;               %-v_l
    milp_ss.Aineq(i,nRxns+l) = -v_min_;         %-v_min_l*yf_l
    milp_ss.bineq(i) = -v_min_;                 %-v_min_
end

for h=1:length(highRxns_ss)
    rxnID_ = highRxns_ss(h);
    v_min_ = model_ss.lb(rxnID_);
    v_max_ = model_ss.ub(rxnID_);
     
    % v_h + yf_h*(v_min_h - eps) >= v_min_h, h in high reactions
    i = 2*length(lowRxns_ss) + h;
    milp_ss.Aineq(i,rxnID_) = -1;               % v_h
    milp_ss.Aineq(i,nRxns+length(lowRxns_ss)+h) = -v_min_ + epsilon;   % (v_min_h - eps)
    milp_ss.bineq(i) = -v_min_;                 % v_min_h
    
    % v_h + yr_h*(v_max_h + eps) <= v_max_h, h in high reactions
    i = 2*length(lowRxns_ss) + length(highRxns_ss) + h;
    milp_ss.Aineq(i,rxnID_) = 1;                % v_h
    milp_ss.Aineq(i,nRxns+length(lowRxns_ss)+length(highRxns_ss)+h) = v_max_ + epsilon;    % (v_max_h + eps)
    milp_ss.bineq(i) = v_max_;                  % v_max_h
end

for l=1:length(lowRxns_5h)
    rxnID_ = lowRxns_5h(l);
    v_min_ = model_5h.lb(l);
    v_max_ = model_5h.ub(l);
    
    % v_l <= v_max_l*(1-yf_l), l in low reactions
    % v_l + v_max_l*yf_l <= v_max_l
    i = l;
    milp_5h.Aineq(i,rxnID_) = 1;                %v_l
    milp_5h.Aineq(i,nRxns+l) = v_max_;          %v_max_l*yf_l
    milp_5h.bineq(i) = v_max_;                  %v_max_l
    
    % v_min_l*(1-yf_l) <= v_l, l in low reactions
    % -v_l - v_min_l*yf_l <= -v_min_l
    i = length(lowRxns_5h) + l;
    milp_5h.Aineq(i,rxnID_) = -1;               %-v_l
    milp_5h.Aineq(i,nRxns+l) = -v_min_;         %-v_min_l*yf_l
    milp_5h.bineq(i) = -v_min_;                 %-v_min_
end

for h=1:length(highRxns_5h)
    rxnID_ = highRxns_5h(h);
    v_min_ = model_5h.lb(rxnID_);
    v_max_ = model_5h.ub(rxnID_);
     
    % v_h + yf_h*(v_min_h - eps) >= v_min_h, h in high reactions
    i = 2*length(lowRxns_5h) + h;
    milp_5h.Aineq(i,rxnID_) = -1;               % v_h
    milp_5h.Aineq(i,nRxns+length(lowRxns_5h)+h) = -v_min_ + epsilon;   % (v_min_h - eps)
    milp_5h.bineq(i) = -v_min_;                 % v_min_h
    
    % v_h + yr_h*(v_max_h + eps) <= v_max_h, h in high reactions
    i = 2*length(lowRxns_5h) + length(highRxns_5h) + h;
    milp_5h.Aineq(i,rxnID_) = 1;                % v_h
    milp_5h.Aineq(i,nRxns+length(lowRxns_5h)+length(highRxns_5h)+h) = v_max_ + epsilon;    % (v_max_h + eps)
    milp_5h.bineq(i) = v_max_;                  % v_max_h
end

% f: objective function
% f --> maximize{sum(yf_h + yr_f) + sum(yf_l)}
milp_ss.f = -1 * [ zeros(nRxns,1); ones(ny_ss,1) ];
milp_5h.f = -1 * [ zeros(nRxns,1); ones(ny_5h,1) ];

% yf and yr in [1,0]
milp_ss.ctype = ''; milp_5h.ctype = '';
for v=1:nRxns
    milp_ss.ctype = strcat(milp_ss.ctype, 'C');
    milp_5h.ctype = strcat(milp_5h.ctype, 'C');
end
for y=1:ny_ss
    milp_ss.ctype = strcat(milp_ss.ctype, 'B');
end
for y=1:ny_5h
    milp_5h.ctype = strcat(milp_5h.ctype, 'B');
end

% v >= v_min
milp_ss.lb = [model_ss.lb; zeros(ny_ss,1)];
milp_5h.lb = [model_5h.lb; zeros(ny_5h,1)];
% v <= v_max
milp_ss.ub = [model_ss.ub; ones(ny_ss,1)];
milp_5h.ub = [model_5h.ub; ones(ny_5h,1)];

% Containers for simulation results:
shlomi_ss = struct;
shlomi_5h = struct;

% Solve!
[shlomi_ss.x,shlomi_ss.fval,shlomi_ss.exitflag,shlomi_ss.output] = ...
    cplexmilp(milp_ss);
[shlomi_5h.x,shlomi_5h.fval,shlomi_5h.exitflag,shlomi_5h.output] = ...
    cplexmilp(milp_5h);

% Gather the results:
ys_ss = shlomi_ss.x(nRxns+1:end);
ys_5h = shlomi_5h.x(nRxns+1:end);

shlomi_ss.actualY = zeros(nRxns,1);
shlomi_5h.actualY = zeros(nRxns,1);
for i=1:length(lowRxns_ss)
shlomi_ss.actualY(lowRxns_ss(i)) = -ys_ss(i);
end
for i=1:length(highRxns_ss)
shlomi_ss.actualY(highRxns_ss(i)) = ys_ss(length(lowRxns_ss)+i) + ys_ss(length(lowRxns_ss)+length(highRxns_ss)+i);
end
for i=1:length(lowRxns_5h)
shlomi_5h.actualY(lowRxns_5h(i)) = -ys_5h(i);
end
for i=1:length(highRxns_5h)
shlomi_5h.actualY(highRxns_5h(i)) = ys_5h(length(lowRxns_5h)+i) + ys_5h(length(lowRxns_5h)+length(highRxns_5h)+i);
end
shlomi_ss.predictedY = zeros(nRxns,1);
shlomi_ss.predictedY(highRxns_ss) = 1;
shlomi_ss.predictedY(lowRxns_ss) = -1;
shlomi_5h.predictedY = zeros(nRxns,1);
shlomi_5h.predictedY(highRxns_5h) = 1;
shlomi_5h.predictedY(lowRxns_5h) = -1;

% Alternate optima analysis to determine confidence levels:
[shlomi_ss.highOrLow,shlomi_ss.confidence,shlomi_ss.maxWhenOn,...
    shlomi_ss.maxWhenOff] =...
    shlomiAltOpt(milp_ss,highRxns_ss,lowRxns_ss,model_ss);

[shlomi_5h.highOrLow,shlomi_5h.confidence,shlomi_5h.maxWhenOn,...
    shlomi_5h.maxWhenOff] =...
    shlomiAltOpt(milp_5h,highRxns_5h,lowRxns_5h,model_5h);